/*
    Here is a way to find the Windows system calls in (virtual) memory.
    Run this program in the Visual Studio debugger and when it blocks on
    reading from standard input, click on the "Debug -> Break" menu item in
    the debugger. When this stops the program, the program will really be in
    kernel mode running the kernel function for reading input. But the debugger
    cannot show kernel memory space. So the debugger will show you the instruction
    in user space that is just after the system call instruction that jumped into
    kernel space (the system call instruction in assembly language is "int 2E").

    To actually see the instruction that the debugger is pointing to, use the
    "View -> Debug Windows -> Disassembly" menu item to switch to the assembly
    language view of memory, then use the "Debug -> Show Next Statement" menu
    item to have the view jump to what the debugger sees as the "next instruction"
    in user space (that is, the instruction just after the system call instruction).

    To find out what system function the system call made, use the menu item
    "View -> Debug Windows -> Call Stack" and look at the top of the call stack.
    It should show an entry point in the dll ntdll.dll (this is the dll in user
    space that holds most of the system call entry points to the actual system
    functions in kernel space). The call stack does not give a symbolic name for
    the system function that the program has called, but it should show the same
    address in memory that the "Show Next Statement" menu item jumped to. Notice
    on the call stack how many functions were called (after fgetc()) before the
    program made the actual transition to operating system code in kernel space.
    (You will see fewer functions on the call stack if you use a Win32 input
    function. Why?.)

    We want to find out exactly which system function in the operating system
    this system call called. We can find this out by using our best friend,
    Dependency Walker (depends.exe). Use Dependecy Walker to open the exe file
    for this program. Find the NTDLL.DLL item in the module list at the bottom
    of the depends.exe window. Right click onthe name NTDLL.DLL and chose the
    "Highlight Matching Module in Tree" menu item. In the "Export Function List
    View" (which is the second window from the top to the right of the module
    tree view) make sure that you can see the column called "Entry Point^" (the
    right most column). Click on that column heading to order the function names
    by their entry points. Now look up the entry point in this list that is closest
    in value to what was on the top of the debugger call stack. That is the system
    call that this program was executing when we interuppted it in the debugger
    (it should be NtReadFile with entry point 0x00002856 where the base address of
    NTDLL.DLL is 0x77F80000, so the actual entry point in virtual memory is 0x77F82856).
*/
#include <stdio.h>
#include <windows.h>

int main()
{
   char c;

   // use a C Standard Library input function
   c = fgetc(stdin);

   // or you can use a Win32 library input function.
   int n;
   HANDLE hIN = GetStdHandle(STD_INPUT_HANDLE);
   ReadFile(hIN, &c, 1, &n, NULL);

   return 0;
}
